#!/usr/bin/env ts-node

// Create an ed25519 signature for a give request Payload from the CLI
//
// Usage:
// ts-node createReqSignatureCLI.ts <request_payload> <private_key>

import { createReqSignature } from './createReqSignature'
import { sign } from 'tweetnacl'

const requestPayload = JSON.parse(process.argv[2])
const keyPair = sign.keyPair.fromSecretKey(
  Buffer.from(process.argv[3], 'base64'),
)

function main() {
  const signature = createReqSignature(requestPayload, keyPair.secretKey)

  console.log(
    `X-Request-Pk-B64: ${Buffer.from(keyPair.publicKey).toString('base64')}`,
  )
  console.log(`X-Request-Sig-B64: ${Buffer.from(signature).toString('base64')}`)
}

main()
